/*
CartoTypeViewController.h
Copyright 2019-2024 CartoType Ltd.
See www.cartotype.com for more information.
*/

#import <CoreLocation/CLLocationManager.h>
#import <CoreLocation/CLLocationManagerDelegate.h>
#import <CartoType/CartoTypeFramework.h>
#import <CartoType/CartoTypeView.h>
#import <CartoType/MGLKit.h>

/**
\file
A graphics-accelerated view controller class.
*/

/**
A view controller class which draws a map using hardware graphics acceleration
and supports the standard gestures to pan, zoom and rotate the map.
*/
@interface CtViewController : MGLKViewController <UIGestureRecognizerDelegate>

/**
Creates a view controller which uses a CtView object to draw the map.
Takes ownership of the supplied framework object.
*/
-(id)init:(CtFramework*)aFramework bounds:(CGRect)aBounds;

/** Creates a view controller with a valid MGLKView which doesn't draw anything. */
-(id)init;

/** Creates a view controller with a valid MGLKView which doesn't draw anything. */
-(id)initWithCoder:(NSCoder *)aDecoder;

/** Sets the framework and bounds of the view controller. The bounds are in logical pixels. */
-(void)setFramework:(CtFramework*)aFramework bounds:(CGRect)aBounds;

/**
Handles a tap gesture at a specified point in degrees latitude and longitude.
The base implementation does nothing, but you can implement this method in your derived class.
*/
-(void)onTap:(CtPoint)aPointInDegrees;

/**
Handles a long press gesture at a specified point in degrees latitude and longitude.
The base implementation does nothing, but you can implement this method in your derived class.
*/
-(void)onLongPress:(CtPoint)aPointInDegrees;

@end

/** A synonym of CtViewController. */
@compatibility_alias CartoTypeViewController CtViewController;
